/* ========================================
 *  TapeDither - TapeDither.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __TapeDither_TapeDither_H
#define __TapeDither_TapeDither_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::TapeDither {
enum {
	kParamA = 0,
	kParamB = 1,
 	kNumParameters = 2
}; //


class TapeDither final : public SfxCoreExtensionV1
{
public:
    TapeDither();
    ~TapeDither();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double previousDither1L;
	double previousDither2L;
	double previousDither3L;
	double previousDither4L;
	double previousDither1R;
	double previousDither2R;
	double previousDither3R;
	double previousDither4R;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
