/* ========================================
 *  TexturizeMS - TexturizeMS.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __TexturizeMS_TexturizeMS_H
#define __TexturizeMS_TexturizeMS_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::TexturizeMS {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class TexturizeMS final : public SfxCoreExtensionV1
{
public:
    TexturizeMS();
    ~TexturizeMS();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	bool polarityM;
	double lastSampleM;
	double iirSampleM;
	double noiseAM;
	double noiseBM;
	double noiseCM;
	bool flipM;
	
	bool polarityS;
	double lastSampleS;
	double iirSampleS;
	double noiseAS;
	double noiseBS;
	double noiseCS;
	bool flipS;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
