/* ========================================
 *  UltrasonicLite - UltrasonicLite.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "UltrasonicLite.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::UltrasonicLite {

UltrasonicLite::UltrasonicLite()
{
	for (int x = 0; x < 15; x++) {biquadA[x] = 0.0;}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int UltrasonicLite::getParameterCount() const
{
  return kNumParameters;
}

void UltrasonicLite::setParameter(int index, float value) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    }
}

float UltrasonicLite::getParameter(int index) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void UltrasonicLite::getParameterName(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void UltrasonicLite::getParameterDisplay(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void UltrasonicLite::getParameterLabel(int index, char *text) {
    switch (index) {
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
