/* ========================================
 *  UnBox - UnBox.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __UnBox_UnBox_H
#define __UnBox_UnBox_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::UnBox {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
};


class UnBox final : public SfxCoreExtensionV1
{
public:
    UnBox();
    ~UnBox();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double aL[5];
	double bL[5];
	double cL[11];
	double aR[5];
	double bR[5];
	double cR[11];
	double e[5];
	double f[11];
	double iirSampleAL;
	double iirSampleBL;
	double iirSampleAR;
	double iirSampleBR;
	

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
