/* ========================================
 *  Verbity2 - Verbity2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Verbity2_Verbity2_H
#define __Verbity2_Verbity2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Verbity2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Verbity2 final : public SfxCoreExtensionV1
{
public:
    Verbity2();
    ~Verbity2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double iirAL;
	double iirBL;
	
	//double aZL[5191];
	
	double aAL[5005]; //AFKPU
	double aFL[4953];
	double aKL[4921];
	double aPL[4801];
	double aUL[4753];
	
	double aBL[4351]; //BGLQV
	double aGL[4159];
	double aLL[3931];
	double aQL[3531];
	double aVL[3331];
	
	double aCL[3325]; //CHMRW
	double aHL[2793];
	double aML[2769];
	double aRL[2391];
	double aWL[2349];
	
	double aDL[2143]; //DINSX
	double aIL[1813];
	double aNL[1735];
	double aSL[1173];
	double aXL[789];
	
	double aEL[679]; //EJOTY
	double aJL[645];
	double aOL[441];
	double aTL[351];
	double aYL[283];
	
	double feedbackAL;
	double feedbackBL;
	double feedbackCL;
	double feedbackDL;
	double feedbackEL;
	
	double previousAL;
	double previousBL;
	double previousCL;
	double previousDL;
	double previousEL;
	
	double lastRefL[7];
	
	double iirAR;
	double iirBR;
	
	//double aZR[5191];
	
	double aAR[5005]; //AFKPU
	double aFR[4953];
	double aKR[4921];
	double aPR[4801];
	double aUR[4753];
	
	double aBR[4351]; //BGLQV
	double aGR[4159];
	double aLR[3931];
	double aQR[3531];
	double aVR[3331];
	
	double aCR[3325]; //CHMRW
	double aHR[2793];
	double aMR[2769];
	double aRR[2391];
	double aWR[2349];
	
	double aDR[2143]; //DINSX
	double aIR[1813];
	double aNR[1735];
	double aSR[1173];
	double aXR[789];
	
	double aER[679]; //EJOTY
	double aJR[645];
	double aOR[441];
	double aTR[351];
	double aYR[283];
	
	double feedbackAR;
	double feedbackBR;
	double feedbackCR;
	double feedbackDR;
	double feedbackER;
	
	double previousAR;
	double previousBR;
	double previousCR;
	double previousDR;
	double previousER;
	
	double lastRefR[7];
	
	int countA, delayA;
	int countB, delayB;
	int countC, delayC;
	int countD, delayD;
	int countE, delayE;
	int countF, delayF;
	int countG, delayG;
	int countH, delayH;
	int countI, delayI;
	int countJ, delayJ;
	int countK, delayK;
	int countL, delayL;		
	int countM, delayM;		
	int countN, delayN;		
	int countO, delayO;		
	int countP, delayP;		
	int countQ, delayQ;		
	int countR, delayR;		
	int countS, delayS;		
	int countT, delayT;		
	int countU, delayU;		
	int countV, delayV;		
	int countW, delayW;		
	int countX, delayX;		
	int countY, delayY;		
	int countZ, delayZ;		
	int cycle;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
