/* ========================================
 *  VinylDither - VinylDither.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __VinylDither_VinylDither_H
#define __VinylDither_VinylDither_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::VinylDither {
enum {
	kParamA = 0,
	kParamB = 1,
 	kNumParameters = 2
}; //


class VinylDither final : public SfxCoreExtensionV1
{
public:
    VinylDither();
    ~VinylDither();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double NSOddL;
	double prevL;
	double nsL[16];
	double NSOddR;
	double prevR;
	double nsR[16];
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
