/* ========================================
 *  Weight - Weight.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Weight.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Weight {

Weight::Weight()
{
	A = 0.5;
	B = 0.0;
	for (int i = 0; i < 8; i++) {
		previousSampleL[i] = 0.0;
		previousTrendL[i] = 0.0;
		previousSampleR[i] = 0.0;
		previousTrendR[i] = 0.0;
	}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Weight::getParameterCount() const
{
  return kNumParameters;
}

void Weight::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Weight::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Weight::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Freq", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Weight", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Weight::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*100.0)+20.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Weight::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "hz", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
