/*
  ZynAddSubFX - a software synthesizer

  FormantFilter.h - formant filter
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu


  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef FORMANT_FILTER_H
#define FORMANT_FILTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "Defines.h"
#include "FilterBase.h"
#include "AnalogFilter.h"
#include "FilterParams.h"

class FormantFilter : public FilterBase
{
public:
  FormantFilter(FilterParams& pars);
  ~FormantFilter();
  void filterout(f32* smp, const i32 blockSize) override;
  void setfreq(f32 frequency) override;
  void setfreq_and_q(f32 frequency, f32 q_) override;
  void setq(f32 q_) override;
  void setgain(f32 dBgain) override;

  void cleanup();
private:
  void setpos(f32 input);

  struct
  {
    f32 freq, amp, q;	//frequency,amplitude,Q
  } formantpar[FF_MAX_VOWELS][FF_MAX_FORMANTS],
    currentformants[FF_MAX_FORMANTS];

  struct
  {
    unsigned char nvowel;
  } sequence[FF_MAX_SEQUENCE];

  i32 sequencesize, numformants, firsttime;

  f32 oldformantamp[FF_MAX_FORMANTS];
  f32 oldinput, slowinput;
  f32 Qfactor, formantslowness, oldQfactor;
  f32 vowelclearness, sequencestretch;

  f32 inbuffer[Const::audioMaximumPossibleBlockSize];
  f32 tmpbuf[Const::audioMaximumPossibleBlockSize];

  AnalogFilter* formant[FF_MAX_FORMANTS];
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
