/*
    HarnEnhancer - Harmonic Enhancer Class

    HarmEnhancer.h  - headers.
    Copyright (C) 2008-2010 Josep Andreu
    Author: Josep Andreu

    Based on Steve Harris LADSPA harmonic

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef HARM_ENHANCER_H
#define HARM_ENHANCER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "AnalogFilter.h"
#include "Compressor.h"

#define HARMONICS 11

class HarmEnhancer
{
public:
  HarmEnhancer(f32* harmonics, f32 hfreq, f32 lfreq, f32 gain);
  void cleanup();
  void chebpc(f32 c[], f32 d[]);
  void calcula_mag(f32* Rmag);
  void harm_out(f32** inOutBlock, i32 blockSize);
  void set_vol(i32 mode, f32 gain);
  void set_freqh(i32 mode, f32 freq);
  void set_freql(i32 mode, f32 freq);

  f32 realvol;
  f32 hpffreq;
  f32 lpffreq;

private:
  f32 inputl[Const::audioMaximumPossibleBlockSize];
  f32 inputr[Const::audioMaximumPossibleBlockSize];
  f32 vol;
  f32 itm1l;
  f32 itm1r;
  f32 otm1l;
  f32 otm1r;

  f32 p[HARMONICS];

  AnalogFilter hpfl;
  AnalogFilter hpfr;
  AnalogFilter lpfl;
  AnalogFilter lpfr;

  Compressor limiter;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
