/*
  ZynAddSubFX - a software synthesizer

  Chorus.h - Chorus and Flange effects
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef CHORUS_H
#define CHORUS_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

class Chorus
{
public:
  Chorus();
  void processBlock(const f32* const * inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;		//this is the volume of effect and is public because need it in system effect. The out volume of s

private:
  //Parametrii Chorus
  EffectLFO lfo;		//lfo-ul chorus
  i32 Pvolume;
  i32 Ppanning;
  i32 Pdepth;		//the depth of the Chorus(ms)
  i32 Pdelay;		//the delay (ms)
  i32 Pfb;		//feedback
  i32 Plrcross;	//feedback
  i32 Pflangemode;	//how the LFO is scaled, to result chorus or flange
  i32 Poutsub;	//if I wish to substract the output instead of the adding it


  //Control Parametrii
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdepth(i32 Pdepth);
  void setdelay(i32 Pdelay);
  void setfb(i32 Pfb);
  void setlrcross(i32 Plrcross);

  //Valorile interne
  i32 maxdelay;
  i32 dlk = 0;
  i32 drk = 0;
  i32 dlhi;
  i32 dlhi2;

  f32 depth, delay, fb, lrcross, panning;
  f32 dl1, dl2, dr1, dr2, lfol, lfor;
  f32* delayl, * delayr;
  f32 getdelay(f32 xlfo);
  f32 dllo, mdel;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
