/*
  Rakarrack   Audio FX software
  CoilCrafter.h - Pick Up Emulation
  Using RBFilter
  Using Steve Harris LADSPA Plugin harmonic_gen
  Modified for rakarrack by Ryan Billing & Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef COILCRAFTER_H
#define COILCRAFTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/HarmonicEnhancer.h"
#include "../common/AnalogFilter.h"

class CoilCrafter
{
public:
  CoilCrafter();
  void processBlock(f32** inOutBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:

  void setvolume(i32 value);
  void sethpf(i32 value);
  void setfreq1();
  void setfreq2();
  void setq1();
  void setq2();

  i32 Pvolume = 50;
  i32 Ppo;
  i32 Ppd;
  i32 Ptone = 20;
  i32 Pq1;
  i32 Pfreq1;
  i32 Pq2;
  i32 Pfreq2;
  i32 Pmode;

  f32 tfreqs[10];
  f32 tqs[10];
  f32 rm[10];
  f32 freq1, q1, freq2, q2;
  f32 att;

  class HarmEnhancer* harm;

  AnalogFilter RB1l;
  AnalogFilter RB1r;
  AnalogFilter RB2l;
  AnalogFilter RB2r;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
