/*
  ZynAddSubFX - a software synthesizer

  DynamicFilter.h - "WahWah" effect and others
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef DYNAMICFILTER_H
#define DYNAMICFILTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"
#include "../common/Filter.h"

class DynamicFilter
{
public:
  DynamicFilter();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);

  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:
  //Parametrii DynamicFilter
  EffectLFO lfo;		//lfo-ul DynamicFilter
  i32 Pvolume;
  i32 Ppanning;
  i32 Pdepth;		//the depth of the lfo of the DynamicFilter
  i32 Pampsns;	//how the filter varies according to the input amplitude
  i32 Pampsnsinv;	//if the filter freq is lowered if the input amplitude rises
  i32 Pampsmooth;	//how smooth the input amplitude changes the filter

  //Control Parametrii
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdepth(i32 Pdepth);
  void setampsns(i32 Pampsns);

  void reinitfilter();

  //Valorile interne

  f32 panning, depth, ampsns, ampsmooth;
  f32 ms1, ms2, ms3, ms4;	//mean squares

  Filter* filterl = nullptr;
  Filter *filterr = nullptr;
  FilterParams filterpars;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
