/*
  ZynAddSubFX - a software synthesizer

  EQ.h - EQ Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef EQ_H
#define EQ_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

#define MAX_EQ_BANDS 16

class EQ
{
public:
  EQ();
  void processBlock(f32** inOutBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  f32 getfreqresponse(f32 freq);
  void setvolume(i32 Pvolume);

  void setpreset_Cabinet(i32 npreset);
  void setpreset_EQ(i32 npreset);
  void setpreset_ParametricEQ(i32 npreset);

  i32 Pvolume;	//Volumul 

  f32 outvolume;		//this is the volume of effect and is public because need it in system effect. The out volume of

  i32 cabinet_preset = 0;

  struct
  {
    //parameters
    i32 Ptype, Pfreq, Pgain, Pq, Pstages;
    //internal values
    AnalogFilter* l, * r;
  } filter[MAX_EQ_BANDS];
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
