/*
  Echotron.h - Convolution-based Echo Effect

  Author: Ryan Billing & Josep Andreu

  Adapted effect structure of ZynAddSubFX - a software synthesizer
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef ECHOTRON_H
#define ECHOTRON_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/EffectLFO.h"

#define  ECHOTRON_F_SIZE   128       //Allow up to 150 points in the file
#define  ECHOTRON_MAXFILTERS  32      //filters available


class Echotron
{
public:
  Echotron();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  i32 Pchange;
  
  f32 outvolume;

private:
  void setProfile(i32 index);
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void sethidamp(i32 Phidamp);
  void setfb(i32 value);
  void init_params();
  void modulate_delay();

  //User input parameters
  EffectLFO lfo;
  EffectLFO dlfo;
  i32 Pvolume = 50;	//This is master wet/dry mix like other FX...but I am finding it is not useful
  i32 Ppanning = 64;	//Panning
  i32 Plrcross = 100;	// L/R Mixing  // 
  i32 Phidamp = 60;
  i32 Ptempo;		//Tempo, BPM//For stretching reverb responses
  i32 Filenum = 0;
  i32 Pfb;		//-64 ... 64// amount of feedback
  i32 Pdepth;
  i32 Pwidth;
  i32 Pfilters;         //0 or 1// use or don't use filters in delay line
  i32 Pmodfilts;	//0 or 1// apply LFO to filter freqs
  i32 Pmoddly;		//0 or 1// apply LFO to delay time
  i32 Pstdiff;
  i32 Plength = 10;

  i32 offset = 0;
  static const i32 maxx_size = SAMPLE_RATE * 6; //6 Seconds delay time

  //arrays of parameters from text file:
  f32 fPan[ECHOTRON_F_SIZE];  //1+Pan from text file
  f32 fTime[ECHOTRON_F_SIZE];
  f32 fLevel[ECHOTRON_F_SIZE];
  f32 fLP[ECHOTRON_F_SIZE];
  f32 fBP[ECHOTRON_F_SIZE];
  f32 fHP[ECHOTRON_F_SIZE];
  f32 fFreq[ECHOTRON_F_SIZE];
  f32 fQ[ECHOTRON_F_SIZE];
  i32 iStages[ECHOTRON_F_SIZE];
  f32 subdiv_dmod = 1.0f;
  f32 subdiv_fmod = 1.0f;
  i32 f_qmode = 0;

  i32 rtime[ECHOTRON_F_SIZE];
  i32 ltime[ECHOTRON_F_SIZE];
  f32 ldata[ECHOTRON_F_SIZE];
  f32 rdata[ECHOTRON_F_SIZE];

  //end text configurable parameters

  i32 initparams;

  f32 ldmod, rdmod, oldldmod, oldrdmod, interpl, interpr;
  f32 dlyrange;

  f32 width, depth;
  f32 lpanning, rpanning, hidamp, alpha_hidamp, convlength;

  f32 lxn[1 + maxx_size];
  f32 rxn[1 + maxx_size];

  f32 level, fb = 0.0f, rfeedback = 0.0f, lfeedback = 0.0f, levpanl, levpanr, lrcross, ilrcross;
  f32 tempo_coeff;

  AnalogFilter lpfl;
  AnalogFilter lpfr;

  struct
  {
    f32 sfreq, sq, sLP, sBP, sHP, sStg;
    class RBFilter* l, * r;

  } filterbank[ECHOTRON_MAXFILTERS];
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // ECHOTRON_H
