/*
  Rakarrack   Audio FX software
  Exciter.h - Harmonic Enhancer
  Based in Steve Harris LADSPA Plugin harmonic_gen
  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef EXCITER_H
#define EXCITER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/HarmonicEnhancer.h"

class Exciter
{
public:
  Exciter();
  void processBlock(f32** inOutBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:
  void setvolume(i32 value);
  void setlpf(i32 value);
  void sethpf(i32 value);
  void sethar(i32 num, i32 value);

  i32 Prm[10]{};
  i32 Pvolume = 50;
  i32 lpffreq = 8000;
  i32 hpffreq = 2500;

  f32 rm[10]{};

  HarmEnhancer harm;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
