
// Based in gate_1410.c LADSPA Swh-plugins

/*
  rakarrack - a guitar effects software

 Gate.h  -  Noise Gate Effect definitions
 Based on Steve Harris LADSPA gate.

  Copyright (C) 2008 Josep Andreu
  Author: Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef NOISEGATE_H
#define NOISEGATE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

class NoiseGate
{
public:
  NoiseGate();

  void processBlock(f32** inOutBlock, i32 blockSize);

  void changepar(i32 np, i32 value);
  void setpreset(i32 npreset);
  void cleanup();
  i32 getpar(i32 npar);

  // Compressor

  i32 Pthreshold;		// attack time  (ms)
  i32 Pattack;			// release time (ms)
  i32 Ohold;
  i32 Pdecay;
  i32 Prange;
  i32 Plpf;
  i32 Phpf;
  i32 Phold;

private:
  void setlpf(i32 Plpf);
  void sethpf(i32 Phpf);

  i32 hold_count;
  i32 state;
  f32 range;
  f32 cut;
  f32 t_level;
  f32 a_rate;
  f32 d_rate;
  f32 env = 0.0f;
  f32 gate = 0.0f;
  f32 fs;
  f32 hold;

  AnalogFilter lpfl;
  AnalogFilter lpfr;
  AnalogFilter hpfl;
  AnalogFilter hpfr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // NOISEGATE_H
