/*
  Reverbtron.h - Reverbtron Effect

  Author: Ryan Billing & Josep Andreu

  Adapted effect structure of ZynAddSubFX - a software synthesizer
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef REVERBTRON_H
#define REVERBTRON_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#ifdef SHR3D_SFX_CORE_RAKARRACK_REVERBTRON

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Resample.h"

class Reverbtron
{
public:
  Reverbtron(i32 DS = 5, i32 uq = 4, i32 dq = 2);
  void processBlock(f32** inOutBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void setProfile(i32 index);
  void adjust(i32 DS, i32 blockSize);
  
  f32 outvolume;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void sethidamp(i32 Phidamp);
  void setlpf(i32 Plpf);
  void setfb(i32 value);
  void convert_time();
  void loaddefault();

  //Parametrii
  i32 Pvolume = 50;	//This is master wet/dry mix like other FX...but I am finding it is not useful
  i32 Ppanning = 64;	//Panning
  i32 Plrcross = 100;	// L/R Mixing  // This is a mono effect, so lrcross and panning are pointless
  i32 Phidamp = 60;
  i32 Plevel;		//This should only adjust the level of the IR effect, and not wet/dry mix
  i32 Plength = 50;		//20... 1500// Set maximum number of IR points to calculate.
  i32 Pstretch;		//-64 ... 64//For stretching reverb responses
  i32 Pidelay;         //0 ... 500ms// initial delay time
  i32 Filenum = 0;
  i32 Psafe = 0;
  i32 Pfb;		//-64 ... 64// amount of feedback
  i32 Pfade = 0;
  i32 Pes;		//0 or 1// Add stereo spatialization
  i32 Prv;              //Shuffle
  i32 Plpf;
  i32 Pdiff = 0;

  i32 imctr = 0;
  i32 imax;
  i32 offset = 0;
  i32 hoffset = 0;
  i32 maxx_size;
  i32 data_length = 0;
  i32 avgtime;
  i32 hrtf_size;
  i32 hlength = 0;
  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;

  i32 time[2000];
  i32 rndtime[2000];
  f64 u_up;
  f64 u_down;
  f32 nfSAMPLE_RATE;

  f32 fstretch = 1.0f;
  f32 idelay = 0.0f;
  f32 ffade = 0.0f;
  f32 maxtime = 0.0f;
  f32 maxdata;
  f32 decay;
  f32 diffusion;
  f32 lpanning;
  f32 rpanning;
  f32 hidamp;
  f32 alpha_hidamp;
  f32 convlength = 10.0f; //max reverb time
  f32 oldl;
  f32 data[2000];
  f32* lxn;
  f32* imdelay;
  f32 ftime[2000];
  f32 tdata[2000];
  f32 rnddata[2000];
  f32* hrtf;
  f32 templ[Const::audioMaximumPossibleBlockSize];
  f32 tempr[Const::audioMaximumPossibleBlockSize];
  f32 level;
  f32 fb = 0.0f;
  f32 feedback = 0.0f;
  f32 levpanl;
  f32 levpanr;
  f32 roomsize;

  Resample U_Resample;
  Resample D_Resample;

  AnalogFilter lpfl;
  AnalogFilter lpfr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_REVERBTRON

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
