/*
  rakarrack - a guitar effects software

  StereoHarm.h  -  Stereo Harmonizer definitions
  Copyright (C) 2008 Josep Andreu
  Author: Josep Andreu

  Using Stephan M. Bernsee smbPitchShifter engine.

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef STEREOHARM_H
#define STEREOHARM_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/SmbPitchShift.h"
#include "../common/Resample.h"

class StereoHarm
{
public:
  StereoHarm(i32 Quality = 4, i32 DS = 5, i32 uq = 4, i32 dq = 2);

  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void adjust(i32 DS);

  i32 Pintervall;
  i32 Pintervalr;

  i32 PMIDI;
  i32 PSELECT;
  i32 mira;
  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;
  i32 window;

  i32 hq;

  f64 u_up;
  f64 u_down;
  f32 nfSAMPLE_RATE;

  f32 outil[Const::audioMaximumPossibleBlockSize]{};
  f32 outir[Const::audioMaximumPossibleBlockSize]{};
  f32 outol[Const::audioMaximumPossibleBlockSize]{};
  f32 outor[Const::audioMaximumPossibleBlockSize]{};
  f32 templ[Const::audioMaximumPossibleBlockSize];
  f32 tempr[Const::audioMaximumPossibleBlockSize];

  f32 outvolume;

private:
  i32 Pvolume;
  i32 Plrcross;
  i32 Pgainl;
  i32 Pgainr;
  i32 Pchromel;
  i32 Pchromer;
  i32 Pnote;
  i32 Ptype;

  f32 gainl, gainr;
  f32 intervall;
  f32 intervalr;
  f32 chromel;
  f32 chromer;
  f32 lrcross;
  void setvolume(i32 Pvolume);
  void seti32erval(i32 chan, i32 value);
  void setchrome(i32 chan, i32 value);
  void setgain(i32 chan, i32 value);
  void setMIDI(i32 PMIDI);
  void setlrcross(i32 value);

  Resample U_Resample;
  Resample D_Resample;

  PitchShifter* PSl, * PSr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // STEREOHARM_H
