// SPDX-License-Identifier: Unlicense

#ifndef SFXCOREEXTENSIONV2BASE_H
#define SFXCOREEXTENSIONV2BASE_H

#include "../../typedefs.h"

#ifdef SHR3D_SFX_CORE_EXTENSION_V2

#define ExtensionV2MaxInstanceCount 16

struct SfxCoreExtensionV2Instance
{
  virtual ProcessBlockResult processBlock(f32** inBlock, f32** outBlock, i32 blockSize) = 0;

  virtual float getParameter(i32 index) const = 0; // get the parameter value at the specified index
  virtual void setParameter(i32 index, f32 value) = 0; // set the parameter at index to value
  virtual void getParameterDisplay(i32 index, char* text) = 0; // text description of the current value
  virtual void resetParameter(i32 index) = 0;
};

struct SfxCoreExtensionV2Base
{
  virtual i32 getParameterCount() const = 0;
  virtual const char8_t* getParameterLabel(i32 index) = 0;
  virtual const char8_t* getParameterName(i32 index) = 0;

  virtual SfxCoreExtensionV2Instance* getInstance(i32 instance) = 0;

  bool (*uiCallback)(struct nk_context* ctx, SfxCoreExtensionV2Base* extension, i32 instance) = nullptr;
};

void RegisterSfxCoreExtensionV2(const char8_t* name, SfxCoreExtensionV2Base* extension);

#endif // SHR3D_SFX_CORE_EXTENSION_V2

#endif // SFXCOREEXTENSIONV2BASE_H
