// SPDX-License-Identifier: Unlicense

#include "api.h"

#ifdef SHR3D_SFX_CORE_EXTENSION_V2

#include <stdio.h>

struct SwapLRInstance final : SfxCoreExtensionV2Instance
{
  ProcessBlockResult processBlock(f32** inBlock, f32** outBlock, const i32 blockSize) override
  {
    for (i32 i = 0; i < blockSize; ++i)
    {
      outBlock[1][i] = inBlock[0][i];
      outBlock[0][i] = inBlock[1][i];
    }

    return ProcessBlockResult::ProcessedInOutBlock;
  }

  f32 getParameter(const i32 /*index*/) const override
  {
    unreachable();
  }

  void setParameter(const i32 /*index*/, const f32 /*value*/) override
  {
    unreachable();
  }

  void getParameterDisplay(const i32 /*index*/, char* /*text*/) override
  {
    unreachable();
  }

  void resetParameter(const i32 /*index*/) override
  {
    unreachable();
  }
};

static struct SwapLR final : SfxCoreExtensionV2Base
{
  SwapLR()
  {
    RegisterSfxCoreExtensionV2(u8"SwapLR", this);
  }

  i32 getParameterCount() const override
  {
    return 0;
  }

  const char8_t* getParameterLabel(const i32 /*index*/) override
  {
    unreachable();
  }

  const char8_t* getParameterName(const i32 /*index*/) override
  {
    unreachable();
  }

  SfxCoreExtensionV2Instance* getInstance(const i32 /*instance*/) override
  {
    // SwapLRInstance does not store any state (parameters, audio buffers). We can get away with having only one instance.
    static SwapLRInstance swapLRInstance;
    return &swapLRInstance;
  }
} swapLR;

#endif // SHR3D_SFX_CORE_EXTENSION_V2
