// SPDX-License-Identifier: Unlicense

#ifndef WINDOW_H
#define WINDOW_H

#include "typedefs.h"

enum struct FullscreenMode : u8;

#ifdef SHR3D_WINDOW_SDL
struct SDL_Window;
union SDL_Event;
#endif // SHR3D_WINDOW_SDL
#ifdef SHR3D_WINDOW_WIN32
typedef struct HWND__* HWND;
typedef struct tagWINDOWPLACEMENT WINDOWPLACEMENT;
typedef long LONG;
#endif // SHR3D_WINDOW_WIN32


#ifdef SHR3D_WINDOW_WIN32
// See https://www.khronos.org/registry/OpenGL/extensions/ARB/WGL_ARB_create_context.txt for all values
#define WGL_CONTEXT_MAJOR_VERSION_ARB             0x2091
#define WGL_CONTEXT_MINOR_VERSION_ARB             0x2092
#define WGL_CONTEXT_PROFILE_MASK_ARB              0x9126

#define WGL_CONTEXT_CORE_PROFILE_BIT_ARB          0x00000001


// See https://www.khronos.org/registry/OpenGL/extensions/ARB/WGL_ARB_pixel_format.txt for all values
#define WGL_DRAW_TO_WINDOW_ARB                    0x2001
#define WGL_ACCELERATION_ARB                      0x2003
#define WGL_SUPPORT_OPENGL_ARB                    0x2010
#define WGL_DOUBLE_BUFFER_ARB                     0x2011
#define WGL_PIXEL_TYPE_ARB                        0x2013
#define WGL_COLOR_BITS_ARB                        0x2014
#define WGL_DEPTH_BITS_ARB                        0x2022
#define WGL_STENCIL_BITS_ARB                      0x2023

#define WGL_FULL_ACCELERATION_ARB                 0x2027
#define WGL_TYPE_RGBA_ARB                         0x202B

#define WGL_SAMPLE_BUFFERS_ARB                    0x2041
#define WGL_SAMPLES_ARB                           0x2042

#endif // SHR3D_WINDOW_WIN32


namespace Window_
{
#ifdef SHR3D_WINDOW_SDL
  void toggleFullscreen(SDL_Window* hwnd, FullscreenMode& fullscreenMode);
  void handleInput(SDL_Event& event);
#endif // SHR3D_WINDOW_SDL
#ifdef SHR3D_WINDOW_WIN32
  extern const LONG windowedStyle;
  extern const LONG borderlessStyle;

  void toggleFullscreen(HWND hwnd, i32 resolutionWidth, i32 resolutionHeight, FullscreenMode& fullscreenMode, WINDOWPLACEMENT& lastWindowPlacement);
#endif // SHR3D_WINDOW_WIN32

#ifdef SHR3D_SFX_PLUGIN
  Shr3DWindow createPluginHostWindow(i32 x, i32 y, i32 width, i32 height);
  void destoryPluginHostWindow(Shr3DWindow window);
  void setPluginHostWindowPosition(Shr3DWindow window, i32 x, i32 y, i32 width, i32 height);
#endif // SHR3D_SFX_PLUGIN

}

#endif // WINDOW_H
