// SPDX-License-Identifier: Unlicense

#ifndef XR_H
#define XR_H

#include "typedefs.h"

#ifdef SHR3D_OPENXR

struct vec3;
struct vec4;
struct mat4;
struct XrQuaternionf;
struct XrVector3f;
struct XrHandJointLocationEXT;
struct XrPosef;
struct XrFovf;
struct XrCompositionLayerProjectionView;
struct XrSwapchainImageBaseHeader;
struct XrActionStatePose;
typedef int64_t XrTime;

#define XR_HAND_JOINT_COUNT_EXT 26

namespace Xr
{
  void handleXrControllerInput();

  mat4 mat4_CreateProjection(float tanAngleLeft, float tanAngleRight, float tanAngleUp, float tanAngleDown, float nearZ, float farZ);
  mat4 mat4_CreateProjectionFov(const XrFovf& fov, float nearZ, float farZ);
  mat4 mat4_InvertRigidBody(const mat4& src);

  mat4 mat4_CreateFromQuaternion(const XrQuaternionf& quat);
  mat4 mat4_CreateTranslationRotation(const XrVector3f& translation, const XrQuaternionf& rotation);

  f32 dotProduct(const vec3& v0, const vec3& v1);
  vec3 quaternionToDirection(const vec4& quat);

  bool isIntersectUiPlaneWithLine(const vec3& linePoint, const vec3& lineDirection, const f32 planePosZ, f32& intersectX, f32& intersectY);

  void calulateControllerUiIntersection(const XrPosef& aimPose, f32& intersectX, f32& intersectY);

  void drawXrControllers(const mat4& viewProjectionMat, const XrActionStatePose controllerActionStatePose[2], const mat4 controllerModel[2], const mat4 aimModel[2]);
  void drawXrCursor(const mat4& viewProjectionMat, f32 inputXRControllerPosX, f32 inputXRControllerPosY, f32 inputXRControllerPosZ);

#ifdef PLATFORM_OPENXR_ANDROID
  void renderHandTracking(const XrHandJointLocationEXT m_jointLocations[2][XR_HAND_JOINT_COUNT_EXT], const mat4& viewProjectionMat);
#endif // PLATFORM_OPENXR_ANDROID

  GLuint GetDepthTexture(GLuint colorTexture);
  void RenderView(const XrCompositionLayerProjectionView& layerView, GLuint colorTexture, GLuint depthTexture, const XrActionStatePose controllerActionStatePose[2], const XrPosef aimPose[2], const mat4 controllerModel[2], const mat4 aimModel[2]
#ifdef PLATFORM_OPENXR_ANDROID
    , const XrHandJointLocationEXT jointLocations[2][XR_HAND_JOINT_COUNT_EXT]
#endif // PLATFORM_OPENXR_ANDROID
  );
}

#endif // SHR3D_OPENXR

#endif // XR_H
