# 🏗️ Building Shr3D

## 🔧 Prerequisites

- `CMake` (for Linux and Visual Studio solution generation)
- `Visual Studio 2022` (for Windows)
- `Android Studio` (for Mobile Platforms)

### 🗔 Windows

**Release Build**

- run

	```batch
	buildWindows.bat
	```

> Note: If Visual Studio 2022 is installed in a non-default location, modify the path in `buildWindows.bat`

**Debug Build**

- run

	```batch
	cmake .
	```

- Open the generated `Shr3D.sln` in Visual Studio 2022.

### 🐧 Linux

**Release Build**

- run

	```bash
	./buildLinux.sh
	```

**Debug Build**

- Open `CMakeLists.txt` in CLion or QtCreator and build it

### 📱 Mobile Platforms (Android / Pico4 / Quest 3)

**Prerequisites (android-sdl only)**

- Download [SDL-release-2.28.5](https://github.com/libsdl-org/SDL/releases/tag/release-2.28.5)
- Extract to `deps/SDL-release-2.28.5`

**Release Build**

- Open the respective project in Android Studio:
  - `android-sdl` for Tablet / Smartphone
  - `android-pico4` for Pico 4
  - `android-quest3` for Quest 3

- run the appropriate build script:

	```bash
	# For Android
	buildAndroid-sdl.bat
	./buildAndroid-sdl.sh
	
	# For Pico 4
	buildAndroid-pico4.bat
	./buildAndroid-pico4.sh
	
	# For Quest 3
	buildAndroid-quest3.bat
	./buildAndroid-quest3.sh
	```

**Debug Build**

- Use Android Studio

> ⚠️ **Important**: For Pico 4, use Android Studio Dolphin 2021.3.1.16. The debugger will not attach on newer versions

### 🌐 Web (Emscripten)

**Prerequisites**

- grab the file and put them to your webserver

	```bash
	curl -O https://shr3d.app/app/index.html \
	     -O https://shr3d.app/app/shr3d.wasm \
	     -O https://shr3d.app/app/shr3d.js \
	     -O https://shr3d.app/app/shr3d.aw.js \
	     -O https://shr3d.app/app/shr3d.ww.js
	```

> ⚠️ **Important**: Shr3d uses `SharedArrayBuffer` for audio threading. 

- Your server must include these headers:

	```
	Cross-Origin-Embedder-Policy: require-corp
	Cross-Origin-Opener-Policy: same-origin
	```

- You should be able to run shr3d in the browser.

**Release Build**

- run

	```bash
	./buildEmscripten.sh
	```

- Replace the `shr3d.*` files on your webserver

**Debug Build**

- run

	```bash
	./buildEmscriptenDebug.sh
	```

- Replace the `shr3d.*` files on your webserver. You will get detailed assert messages in the web console.
