#! /bin/bash

# download emsdk if it is not installed
if [ ! -d "deps/emsdk/" ]; then
	cd deps
	git clone https://github.com/emscripten-core/emsdk.git
	cd emsdk
	git pull
	./emsdk install latest
	./emsdk activate latest
	cd  ../..
fi

# compile Shr3D using emcc
cd deps/emsdk/
source ./emsdk_env.sh
cd ../..
emcc -std=c++20 -O3 -DNDEBUG -sEXPORTED_RUNTIME_METHODS=[ccall] -sEXPORTED_FUNCTIONS=[_main,_malloc,_free] -flto -funsafe-math-optimizations -fno-exceptions -fno-rtti shr3d.cpp -sUSE_SDL=2 -sMIN_WEBGL_VERSION=2 -sMAX_WEBGL_VERSION=2 -sFETCH -sWASM_WORKERS=1 -sAUDIO_WORKLET=1 -sASYNCIFY -sTOTAL_MEMORY=33554432 -sMAXIMUM_MEMORY=4GB -sALLOW_MEMORY_GROWTH=1 -sSTACK_SIZE=1048576 -o "shr3d.js"
