// SPDX-License-Identifier: Unlicense

#ifndef CAMERA_H
#define CAMERA_H

#include "type.h"

namespace Camera
{
  mat4 calculateViewMat(CameraMode cameraMode, ArrangementIndex selectedArrangementIndex, vec3& cameraTargetPosition, vec3& cameraCurrentPosition);
#ifndef PLATFORM_OPENXR_ANDROID
  mat4 calculateProjectionViewMat(i32 resolutionWidth, i32 resolutionHeight, const mat4& viewMat);
#endif // PLATFORM_OPENXR_ANDROID
  mat4 calculateHighwayProjectionViewMat(CameraMode cameraMode, const mat4& viewProjectionMat, vec3& highwayTargetPosition, vec3& highwayCurrentPosition);
}

#endif // CAMERA_H
