// SPDX-License-Identifier: Unlicense

#ifndef FILE_H
#define FILE_H

#include "typedefs.h"

#include <string>
#include <vector>
#include <map>

namespace File
{
  enum struct Type
  {
    shred,
    psarc,
    png,
    dds,
    astc,
#ifdef SHR3D_ENVIRONMENT_SKYBOX
    astc6, // skybox on android
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_ENVIRONMENT_STAGE
    stage,
    stage_a,
#endif // SHR3D_ENVIRONMENT_STAGE
    unknown
  };

  bool exists(const char8_t* filePath);
  bool directoryExists(const char8_t* filePath);
  const char8_t* filename(const char8_t* filePath);
  const char8_t* extension(const char8_t* filePath);
  std::u8string replaceExtension(const char8_t* filePath, const char8_t* newExtension);

  void createDirectories(const char8_t* filePath);
  void copy(const char8_t* srcFilepath, const char8_t* destFilepath);
  std::vector<std::u8string> filesInDirectory(const char8_t* filePath);
  std::u8string fixInvalidCharsInFilepath(const std::u8string& filePath);
  std::u8string uniqueFilepathInDirectory(const std::u8string& directory, const std::u8string& extension);

//#ifndef PLATFORM_EMSCRIPTEN
  FILE* fopen_u8(const char8_t* filePath, bool isWrite);
  std::vector<u8> read(const char8_t* filePath);
  void write(const char8_t* filePath, const void* content, size_t len);
//#endif // PLATFORM_EMSCRIPTEN

  std::vector<std::u8string> openFileDialog(const wchar_t* filter, bool allowMultiSelect);
  std::u8string openDirectoryDialog();

  void shellExecute(const char8_t* filePathOrUrl);
  void createPathDirectories();

#ifdef PLATFORM_EMSCRIPTEN
  Type type_cacheIpfsCid(const char8_t* filePath, const u8* fileData4CC);
#endif // PLATFORM_EMSCRIPTEN
  Type type(const char8_t* filePath);
}

#endif // FILE_H
