// SPDX-License-Identifier: Unlicense

#ifndef HIGHWAY_H
#define HIGHWAY_H

#include "type.h"

struct Tuning;
namespace Arrangement { struct Info; }

namespace Highway
{
  struct Ctx
  {
    const Arrangement::Info* arrangement = nullptr;
    i8 instrumentStringCount = 6;
    i8 instrumentStringOffset = 0; // on 7 string notes need to be moved up by one string. This this to 1 in this case.
    i8 instrumentHideFirstStrings = 0;
    const i32* instrumentFirstWoundString = nullptr;
    const vec4* instrumentStringColors = nullptr;
    const f32* instrumentStringSpacing = nullptr;
    f32 instrumentFretPosition[25];
    mutable f32 highwayStringFadeUnplayedDecayTime[8];
    mutable f32 vuMeterInputPeakVolumeDB = -F32::inf;
    mutable TimeNS vuMeterInputPeakTime;
  };

  void tick(Ctx& ctx, ArrangementIndex selectedArrangementIndex);
  void render(const Ctx& ctx, ArrangementIndex selectedArrangementIndex, const mat4& highwayViewProjectionMat);
}

#endif // HIGHWAY_H
