// SPDX-License-Identifier: Unlicense

#ifndef PSARC_H
#define PSARC_H

#include "typedefs.h"

#ifdef SHR3D_PSARC

#include <string>
#include <vector>

namespace Psarc
{
  struct Info
  {
    struct
    {
      u32 magicNumber;
      u32 version;
      u32 compressMethod;
      u32 totalTocSize;
      u32 TOCEntrySize;
      u32 numFiles;
      u32 blockSizeAlloc;
      u32 archiveFlags;
    } header;

    std::vector<u8> tocRaw;
    struct TOCEntry
    {
      std::u8string name;
      u8 md5[16];
      u32 zIndexBegin;
      u64 length;
      u64 offset;
      std::vector<u8> content;
    };
    std::vector<TOCEntry> tocEntries;
  };

  Info parse(const u8* psarcData, u64 psarcDataSize);
}

#endif // SHR3D_PSARC

#endif // PSARC_H