// SPDX-License-Identifier: Unlicense

#ifndef SETTINGS_H
#define SETTINGS_H

#include "const.h"
#include "helper.h"

namespace Settings
{
  extern Instrument applicationInstrument;
#ifdef SHR3D_COOP
  extern Instrument applicationInstrumentCoop;
#endif // SHR3D_COOP
  extern BackupMode applicationBackupMode;
  extern EndOfSong applicationEndOfSong;
  extern bool applicationToneSwitch;
  extern AudioSystem audioSystem;
  extern f32 audioEffectVolume;
  extern f32 audioEffectVolumeCoop;
  extern f32 audioMusicVolume;
#ifdef SHR3D_AUDIO_AAUDIO
  extern i32 audioAAudioBlockSize;
  extern i32 audioAAudioChannelInput;
#ifdef SHR3D_COOP
  extern i32 audioAAudioChannelInputCoop;
#endif // SHR3D_COOP
  extern std::string audioAAudioDeviceInput;
  extern std::string audioAAudioDeviceOutput;
  extern i32 audioAAudioSampleRate;
  extern bool audioAAudioExclusiveMode;
  extern AAudioPerformanceMode audioAAudioPerformanceMode;
#endif // SHR3D_AUDIO_AAUDIO
#ifdef SHR3D_AUDIO_ASIO
  extern std::string audioAsioDevice;
  extern i32 audioAsioChannelInput0;
  extern i32 audioAsioChannelInput1;
#ifdef SHR3D_COOP
  extern i32 audioAsioChannelInputCoop0;
  extern i32 audioAsioChannelInputCoop1;
#endif // SHR3D_COOP
#ifdef SHR3D_SFX_CORE_HEXFIN_DIVIDED
#ifdef SHR3D_AUDIO_ASIO_SECOND_DEVICE_FOR_TUNER_DIVIDED
  extern std::string audioAsioSecondDeviceForTunerDivided;
#endif // SHR3D_AUDIO_ASIO_SECOND_DEVICE_FOR_TUNER_DIVIDED
  extern bool audioAsioDividedPickup;
  extern bool audioAsioDividedPickupAsMainInput;
  extern i32 audioAsioDividedPickupChannelString0;
  extern i32 audioAsioDividedPickupChannelString1;
  extern i32 audioAsioDividedPickupChannelString2;
  extern i32 audioAsioDividedPickupChannelString3;
  extern i32 audioAsioDividedPickupChannelString4;
  extern i32 audioAsioDividedPickupChannelString5;
#endif // SHR3D_SFX_CORE_HEXFIN_DIVIDED
  extern i32 audioAsioChannelOutput;
  extern i32 audioAsioBlockSize;
  extern i32 audioAsioSampleRate;
#endif // SHR3D_AUDIO_ASIO
#ifdef SHR3D_AUDIO_JACK
  extern std::string audioJackInputDevice0;
  extern std::string audioJackInputDevice1;
  extern std::string audioJackOutputDevice0;
  extern std::string audioJackOutputDevice1;
#ifdef SHR3D_COOP
  extern std::string audioJackInputDeviceCoop0;
  extern std::string audioJackInputDeviceCoop1;
#endif // SHR3D_COOP
#ifdef SHR3D_SFX_CORE_HEXFIN_DIVIDED
  extern bool audioJackDividedPickup;
  extern bool audioJackDividedPickupAsMainInput;
  extern std::string audioJackDividedPickupChannelString0;
  extern std::string audioJackDividedPickupChannelString1;
  extern std::string audioJackDividedPickupChannelString2;
  extern std::string audioJackDividedPickupChannelString3;
  extern std::string audioJackDividedPickupChannelString4;
  extern std::string audioJackDividedPickupChannelString5;
#endif // SHR3D_SFX_CORE_HEXFIN_DIVIDED
#endif // SHR3D_AUDIO_JACK
#ifdef SHR3D_AUDIO_PIPEWIRE
  extern std::string audioPipewireInputDevice0;
  extern std::string audioPipewireInputDevice1;
  extern std::string audioPipewireOutputDevice0;
  extern std::string audioPipewireOutputDevice1;
#ifdef SHR3D_COOP
  extern std::string audioPipewireInputDeviceCoop0;
  extern std::string audioPipewireInputDeviceCoop1;
#endif // SHR3D_COOP
#ifdef SHR3D_SFX_CORE_HEXFIN_DIVIDED
  extern bool audioPipewireDividedPickup;
  extern bool audioPipewireDividedPickupAsMainInput;
  extern std::string audioPipewireDividedPickupChannelString0;
  extern std::string audioPipewireDividedPickupChannelString1;
  extern std::string audioPipewireDividedPickupChannelString2;
  extern std::string audioPipewireDividedPickupChannelString3;
  extern std::string audioPipewireDividedPickupChannelString4;
  extern std::string audioPipewireDividedPickupChannelString5;
#endif // SHR3D_SFX_CORE_HEXFIN_DIVIDED
#endif // SHR3D_AUDIO_PIPEWIRE
#ifdef SHR3D_AUDIO_SDL
  extern i32 audioSdlBlockSize;
  extern i32 audioSdlChannelInput;
#ifdef SHR3D_COOP
  extern i32 audioSdlChannelInputCoop;
#endif // SHR3D_COOP
  extern std::string audioSdlDeviceInput;
  extern std::string audioSdlDeviceOutput;
  extern i32 audioSdlSampleRate;
#endif // SHR3D_AUDIO_SDL
#ifdef SHR3D_AUDIO_SUPERPOWERED
  extern i32 audioSuperpoweredBlockSize;
  extern std::u8string audioSuperpoweredCofiguration;
  extern i32 audioSuperpoweredChannelInput;
  extern i32 audioSuperpoweredChannelOutput;
  extern std::u8string audioSuperpoweredDeviceInput;
  extern std::u8string audioSuperpoweredDeviceOutput;
  extern bool audioSuperpoweredSustainedPerformanceMode;
  extern std::u8string audioSuperpoweredInputPathName;
  extern std::vector<char> audioSuperpoweredInputMutes;
  extern std::vector<f32> audioSuperpoweredInputVolume;
  extern std::u8string audioSuperpoweredOutputPathName;
  extern std::vector<char> audioSuperpoweredOutputMutes;
  extern std::vector<f32> audioSuperpoweredOutputVolume;
#ifdef SHR3D_SFX_CORE_HEXFIN_DIVIDED
  extern bool audioSuperpoweredDividedPickup;
  extern i32 audioSuperpoweredDividedPickupChannelString0;
  extern i32 audioSuperpoweredDividedPickupChannelString1;
  extern i32 audioSuperpoweredDividedPickupChannelString2;
  extern i32 audioSuperpoweredDividedPickupChannelString3;
  extern i32 audioSuperpoweredDividedPickupChannelString4;
  extern i32 audioSuperpoweredDividedPickupChannelString5;
#endif // SHR3D_SFX_CORE_HEXFIN_DIVIDED
#endif // SHR3D_AUDIO_SUPERPOWERED
#ifdef SHR3D_AUDIO_WASAPI
  extern i32 audioWasapiChannelInput0;
#ifdef SHR3D_COOP
  extern i32 audioWasapiChannelInput1;
#endif // SHR3D_COOP
  extern std::string audioWasapiDeviceInput;
  extern std::string audioWasapiDeviceOutput;
  extern i32 audioWasapiBlockSize;
  extern bool audioWasapiExclusiveMode;
  extern i32 audioWasapiSampleRate;
#endif // SHR3D_AUDIO_WASAPI
#ifdef SHR3D_AUDIO_WEBAUDIO
  extern i32 audioWebAudioChannelInput0;
  extern i32 audioWebAudioSampleRate;
#endif // SHR3D_AUDIO_WEBAUDIO
  extern vec4 environmentClearColor;
#ifdef SHR3D_ENVIRONMENT_MILK
  extern bool environmentMilk;
  extern std::u8string environmentMilkActivePresets;
  extern f32 environmentMilkBeatSensitivity;
  extern i32 environmentMilkDuration;
  extern i32 environmentMilkMeshSize;
  extern i32 environmentMilkFrameSkip;
  extern f32 environmentMilkFrameSpeed;
  extern bool environmentMilkShuffle;
#endif // SHR3D_ENVIRONMENT_MILK
#ifdef SHR3D_ENVIRONMENT_SKYBOX
  extern std::u8string environmentSkybox;
  extern f32 environmentSkyboxRotation;
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_ENVIRONMENT_STAGE
  extern std::u8string environmentStage;
#ifndef PLATFORM_OPENXR_ANDROID
  extern f32 environmentStagePlayerHeight;
#endif // PLATFORM_OPENXR_ANDROID
  extern f32 environmentStageRotation;
  extern f32 environmentStageScale;
  extern f32 environmentStageX;
  extern f32 environmentStageY;
  extern f32 environmentStageZ;
#endif // SHR3D_ENVIRONMENT_STAGE
  extern CameraMode cameraMode;
#ifndef PLATFORM_OPENXR_ANDROID
  extern f32 cameraFieldOfView; // in openxr the fov is comming from the openxr runtime and depends on the headset
#endif // PLATFORM_OPENXR_ANDROID
  extern f32 cameraFixedX;
  extern f32 cameraFixedXRotation;
  extern f32 cameraFixedY;
  extern f32 cameraFixedYRotation;
  extern f32 cameraFixedZ;
  extern f32 cameraParallaxAnchorTackingDuration;
  extern f32 cameraParallaxHighwayRotation;
  extern f32 cameraParallaxHighwayScale;
  extern f32 cameraParallaxHighwayX;
  extern f32 cameraParallaxHighwayXFactor;
  extern f32 cameraParallaxHighwayY;
  extern f32 cameraParallaxHighwayYFactor;
  extern f32 cameraParallaxHighwayZ;
  extern f32 cameraParallaxHighwayZFactor;
  extern f32 cameraParallaxX;
  extern f32 cameraParallaxXFactor;
  extern f32 cameraParallaxXRotation;
  extern f32 cameraParallaxY;
  extern f32 cameraParallaxYFactor;
  extern f32 cameraParallaxYRotation;
  extern f32 cameraParallaxZ;
  extern f32 cameraParallaxZFactor;
#ifdef SHR3D_OPENXR_PCVR
  extern CameraMode cameraPcVrMode;
  extern f32 cameraPcVrParallaxAnchorTackingDuration;
  extern f32 cameraPcVrParallaxHighwayRotation;
  extern f32 cameraPcVrParallaxHighwayScale;
  extern f32 cameraPcVrParallaxHighwayX;
  extern f32 cameraPcVrParallaxHighwayXFactor;
  extern f32 cameraPcVrParallaxHighwayY;
  extern f32 cameraPcVrParallaxHighwayYFactor;
  extern f32 cameraPcVrParallaxHighwayZ;
  extern f32 cameraPcVrParallaxHighwayZFactor;
  extern f32 cameraPcVrParallaxX;
  extern f32 cameraPcVrParallaxXFactor;
  extern f32 cameraPcVrParallaxXRotation;
  extern f32 cameraPcVrParallaxY;
  extern f32 cameraPcVrParallaxYFactor;
  extern f32 cameraPcVrParallaxYRotation;
  extern f32 cameraPcVrParallaxZ;
  extern f32 cameraPcVrParallaxZFactor;
#endif // SHR3D_OPENXR_PCVR
  extern FullscreenMode graphicsFullscreen;
#ifdef SHR3D_GRAPHICS_MSAA
  extern i32 graphicsMSAA; // 0=Off, 1=2x, 2=4x, 3=8x
#endif // SHR3D_GRAPHICS_MSAA
  extern ScalingMode graphicsScaling;
#ifdef SHR3D_OPENGL_SPIR_V
  extern bool graphicsSpirV;
#endif // SHR3D_OPENGL_SPIR_V
#ifdef PLATFORM_QUEST_3
  extern i32 graphicsRefreshRate;
#endif // PLATFORM_QUEST_3
#if !defined(PLATFORM_EMSCRIPTEN) && !defined(PLATFORM_QUEST_3)
  extern VSyncMode graphicsVSync;
#endif // !PLATFORM_EMSCRIPTEN && !PLATFORM_QUEST_3
  extern i32 graphicsWindowWidth;
  extern i32 graphicsWindowHeight;
  extern f32 highwayFadeFarDistance;
  extern f32 highwayFadeNearDistance;
  extern f32 highwayFadeNearStrength;
  extern vec4 highwayAnchorColor[4];
  extern f32 highwayAnchorColorExponent;
  extern vec4 highwayCapoColor;
  extern bool highwayChordBox;
  extern vec4 highwayChordBoxColor;
  extern bool highwayChordBoxArpeggio;
  extern vec4 highwayChordBoxArpeggioColor;
  extern bool highwayChordFretNumbers;
  extern bool highwayChordName;
  extern vec4 highwayChordNameColor;
  extern vec4 highwayDotInlayColor[4];
  extern bool highwayBeat;
  extern vec4 highwayBeatColor[2];
  extern bool highwayBeatStrumDirection;
  extern vec4 highwayBeatStrumDirectionColor[2];
  extern StrumDirection highwayBeatStrumDirectionPrimary;
  extern StrumDirection highwayBeatStrumDirectionNext;
  extern int highwayBeatStrumsBetweenBeats;
  extern vec4 highwayFingerNumberColor;
  extern bool highwayFingerNumbers;
  extern vec4 highwayFretboardFretColor;
  extern vec4 highwayFretboardFretNumberColor[3];
  extern bool highwayFretboardNoteNames;
  extern vec4 highwayFretboardNoteNameColor[2];
  extern bool highwayFretboardCollisionNotes;
  extern vec4 highwayFretboardCollisionNotesColor[2];
  extern bool highwayFretboardPlayedNotesDot;
  extern vec4 highwayFretboardPlayedNotesDotColor[2];
#ifdef SHR3D_SFX_CORE_HEXFIN
  extern bool highwayFretboardPlayedNotesTuner;
#endif // SHR3D_SFX_CORE_HEXFIN
  extern vec4 highwayGroundFretColor[2];
  extern bool highwayStringFadeUnplayed;
  extern vec4 highwaySustainColor;
  extern bool highwayInstrumentBass5StringHideString0;
  extern i32 highwayInstrumentBass5StringTuning[4];
  extern i32 highwayInstrumentBassFirstWoundString;
  extern f32 highwayInstrumentBassFretSpacing;
  extern f32 highwayInstrumentBassFretSpacingFactor;
  extern vec4 highwayInstrumentBassStringColor[6];
  extern f32 highwayInstrumentBassStringSpacing;
  extern bool highwayInstrumentGuitar7StringHideString0;
  extern i32 highwayInstrumentGuitar7StringTuning[6];
  extern i32 highwayInstrumentGuitarFirstWoundString;
  extern f32 highwayInstrumentGuitarFretSpacing;
  extern f32 highwayInstrumentGuitarFretSpacingFactor;
  extern vec4 highwayInstrumentGuitarStringColor[8];
  extern f32 highwayInstrumentGuitarStringSpacing;
  extern f32 highwayNoteBendCurve;
  extern f32 highwayNoteBendEndTime;
  extern f32 highwayNoteBendSpeed;
  extern f32 highwayNoteBendHintOffset;
  extern f32 highwayNoteBendHintDistance;
  extern f32 highwayNoteHeight;
  extern i32 highwayNoteRotate;
  extern f32 highwayNoteRotateEndTime;
  extern f32 highwayNoteRotateSpeed;
  extern NoteShape highwayNoteShape;
  extern NoteSymbols highwayNoteSymbolFretMute;
  extern NoteSymbols highwayNoteSymbolHammerOn;
  extern NoteSymbols highwayNoteSymbolHarmonic;
  extern NoteSymbols highwayNoteSymbolPinchHarmonic;
  extern NoteSymbols highwayNoteSymbolPalmMute;
  extern NoteSymbols highwayNoteSymbolPop;
  extern NoteSymbols highwayNoteSymbolPullOff;
  extern NoteSymbols highwayNoteSymbolSlap;
  extern NoteSymbols highwayNoteSymbolTap;
  extern bool highwayNoteStand;
  extern bool highwayNoteStandZero;
  extern f32 highwayNoteWidth;
  extern f32 highwayNoteSustainCurveSampleDistance;
  extern f32 highwayNoteSustainTremoloSampleDistance;
  extern f32 highwayNoteSustainTremoloShakeStrength;
  extern f32 highwayNoteSustainWidth;
  extern f32 highwayNoteSustainWidthZero;
  extern f32 highwayFretboardNoteHeight;
  extern f32 highwayFretboardNoteWidth;
  extern bool highwayFretboardStringNoteNames;
#ifdef SHR3D_PARTICLE
  extern bool highwayParticlePlayedNotes;
  extern bool highwayParticleCollisionNotes;
  extern i32 highwayParticleShape;
  extern i32 highwayParticleMaxCount;
  extern f32 highwayParticleSpawnsPerSecond;
  extern f32 highwayParticleSpawnRadius;
  extern f32 highwayParticleMinSize;
  extern f32 highwayParticleMaxSize;
  extern f32 highwayParticleMinLifeTime;
  extern f32 highwayParticleMaxLifeTime;
  extern f32 highwayParticleColorVariation;
  extern f32 highwayParticleMinVelocityX;
  extern f32 highwayParticleMaxVelocityX;
  extern f32 highwayParticleMinVelocityY;
  extern f32 highwayParticleMaxVelocityY;
  extern f32 highwayParticleMinVelocityZ;
  extern f32 highwayParticleMaxVelocityZ;
  extern f32 highwayParticleAccelerationX;
  extern f32 highwayParticleAccelerationY;
  extern f32 highwayParticleAccelerationZ;
  extern f32 highwayParticleMinRotationAngle;
  extern f32 highwayParticleMaxRotationAngle;
#endif // SHR3D_PARTICLE
#ifdef SHR3D_RENDERER_DEVELOPMENT
  extern Renderer highwayRenderer;
#endif // SHR3D_RENDERER_DEVELOPMENT
  extern bool highwayReverseStrings;

  extern f32 highwayScrollSpeed;
#ifdef SHR3D_SFX_CORE_HEXFIN
  extern bool highwayTuner;
  extern vec4 highwayTunerColor[4];
#endif // SHR3D_SFX_CORE_HEXFIN
  extern bool highwayVUMeter;
  extern vec4 highwayVUMeterColor[5];
  extern f32 highwayViewDistance;
#ifdef SHR3D_OPENXR
  extern f32 hudDebugXrScale;
  extern f32 hudDebugXrX;
  extern f32 hudDebugXrY;
  extern f32 hudDebugXrZ;
#endif // SHR3D_OPENXR
  extern bool hudLyrics;
  extern vec4 hudLyricsColor[3];
  extern f32 hudLyricsScale;
  extern f32 hudLyricsX;
  extern f32 hudLyricsY[2];
  extern bool hudNewHighscore;
#ifdef SHR3D_HUD_DEVELOPMENT
  extern Renderer hudRenderer;
#endif // SHR3D_HUD_DEVELOPMENT
  extern bool hudTimelineLevel;
  extern vec4 hudTimelineLevelColor[8];
  extern bool hudTimelineLevelFlipY;
  extern f32 hudTimelineLevelScaleX;
  extern f32 hudTimelineLevelScaleY;
  extern f32 hudTimelineLevelSpacing;
  extern f32 hudTimelineLevelX;
  extern f32 hudTimelineLevelY;
#ifdef SHR3D_OPENXR
  extern bool hudTimelineLevelXrFlipY;
  extern f32 hudTimelineLevelXrScaleX;
  extern f32 hudTimelineLevelXrScaleY;
  extern f32 hudTimelineLevelXrSpacing;
  extern f32 hudTimelineLevelXrX;
  extern f32 hudTimelineLevelXrY;
  extern f32 hudTimelineLevelXrZ;
#endif // SHR3D_OPENXR
#ifdef SHR3D_MUSIC_STRETCHER
  extern bool hudTimelineMusicStretcher;
  extern vec4 hudTimelineMusicStretcherColor[2];
  extern f32 hudTimelineMusicStretcherScaleX;
  extern f32 hudTimelineMusicStretcherScaleY;
  extern f32 hudTimelineMusicStretcherX;
  extern f32 hudTimelineMusicStretcherY;
#ifdef SHR3D_OPENXR
  extern f32 hudTimelineMusicStretcherXrScaleX;
  extern f32 hudTimelineMusicStretcherXrScaleY;
  extern f32 hudTimelineMusicStretcherXrX;
  extern f32 hudTimelineMusicStretcherXrY;
  extern f32 hudTimelineMusicStretcherXrZ;
#endif // SHR3D_OPENXR
#endif // SHR3D_MUSIC_STRETCHER
  extern bool hudTimelineTone;
  extern vec4 hudTimelineToneColor[11];
  extern f32 hudTimelineToneScaleX;
  extern f32 hudTimelineToneScaleY;
  extern f32 hudTimelineToneX;
  extern f32 hudTimelineToneY;
#ifdef SHR3D_OPENXR
  extern f32 hudTimelineToneXrScaleX;
  extern f32 hudTimelineToneXrScaleY;
  extern f32 hudTimelineToneXrX;
  extern f32 hudTimelineToneXrY;
  extern f32 hudTimelineToneXrZ;
#endif // SHR3D_OPENXR
  extern vec4 hudTimelineQuickRepeaterColor[2];
  extern bool hudTimelineQuickRepeaterFlipY;
  extern f32 hudTimelineQuickRepeaterScaleY;
  extern f32 hudTimelineQuickRepeaterX;
  extern f32 hudTimelineQuickRepeaterY;
#ifdef SHR3D_OPENXR
  extern f32 hudTimelineQuickRepeaterXrScaleX;
  extern f32 hudTimelineQuickRepeaterXrScaleY;
  extern f32 hudTimelineQuickRepeaterXrX;
  extern f32 hudTimelineQuickRepeaterXrY;
  extern f32 hudTimelineQuickRepeaterXrZ;
#endif // SHR3D_OPENXR
  extern bool hudScore;
  extern vec4 hudScoreColor[4];
  extern bool hudSongInfo;
  extern vec4 hudSongInfoColor[2];
  extern f32 hudSongInfoScale[2];
  extern f32 hudSongInfoX;
  extern f32 hudSongInfoY[2];
  extern bool hudArrangementSwitch;
  extern vec4 hudArrangementSwitchColor;
  extern f32 hudArrangementSwitchScaleX;
  extern f32 hudArrangementSwitchScaleY;
  extern f32 hudArrangementSwitchX;
  extern f32 hudArrangementSwitchY;
#ifdef SHR3D_OPENXR
  extern f32 hudArrangementSwitchXrScaleX;
  extern f32 hudArrangementSwitchXrScaleY;
  extern f32 hudArrangementSwitchXrX;
  extern f32 hudArrangementSwitchXrY;
  extern f32 hudArrangementSwitchXrZ;
#endif // SHR3D_OPENXR
  extern bool hudToneSwitch;
  extern bool hudToneSwitchTimer;
  extern vec4 hudToneSwitchColor;
  extern vec4 hudToneSwitchHintColor;
  extern f32 hudToneSwitchScale[2];
  extern f32 hudToneSwitchX;
  extern f32 hudToneSwitchY[2];
#ifdef SHR3D_OPENXR
  extern f32 hudToneSwitchXrScale[2];
  extern f32 hudToneSwitchXrX;
  extern f32 hudToneSwitchXrY[2];
  extern f32 hudToneSwitchXrZ;
#endif // SHR3D_OPENXR
  extern bool hudWatermark;
  extern vec4 hudWatermarkColor;
#ifdef SHR3D_OPENXR
  extern f32 hudWatermarkXrX;
  extern f32 hudWatermarkXrY;
  extern f32 hudWatermarkXrZ;
#endif // SHR3D_OPENXR
  extern bool metronomeEnabled;
  extern f32 metronomeVolume;
  extern bool metronomeDecay;
  extern f32 metronomeFrequency0;
  extern f32 metronomeFrequency1;
  extern i32 metronomeClickLength;
  extern MetronomeSide metronomeSide;
  extern std::u8string midiAutoConnectDevices;
  extern u8 midiBinding[128];
  extern f32 midiFineValueFactor;
  extern NoteDetectionSource tunerNoteDetectionSource;
  extern std::u8string pathStatsIni;
  extern std::u8string pathTonesIni;
  extern std::u8string pathBackup;
#ifdef SHR3D_SHRED_OR_PSARC
  extern std::u8string pathCache;
#endif // SHR3D_SHRED_OR_PSARC
#ifdef SHR3D_SFX_PLUGIN_CLAP
  extern std::u8string pathClap;
#endif // SHR3D_SFX_PLUGIN_CLAP
#ifdef SHR3D_ENVIRONMENT_MILK
  extern std::u8string pathMilk;
#endif // SHR3D_ENVIRONMENT_MILK
#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
  extern std::u8string pathNam;
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
#ifdef SHR3D_PSARC
  extern std::u8string pathPsarc;
#endif // SHR3D_PSARC
#ifdef SHR3D_SHRED
  extern std::u8string pathShred;
#endif // SHR3D_SHRED
#ifdef SHR3D_RECORDER
  extern std::u8string pathRecorder;
#endif // SHR3D_RECORDER
#ifdef SHR3D_SFX_PLUGIN_VST
  extern std::u8string pathVst;
#endif // SHR3D_SFX_PLUGIN_VST
#ifdef SHR3D_SFX_PLUGIN_VST3
  extern std::u8string pathVst3;
#endif // SHR3D_SFX_PLUGIN_VST3
#ifdef SHR3D_ENVIRONMENT_SKYBOX
  extern std::u8string pathSkybox;
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_ENVIRONMENT_STAGE
  extern std::u8string pathStage;
#endif // SHR3D_ENVIRONMENT_STAGE
#ifdef SHR3D_SPOTIFY
  extern std::string spotifyRedirectUri;
  extern std::string spotifyClientId;
  extern std::string spotifyClientSecret;
#endif // SHR3D_SPOTIFY
#ifdef SHR3D_SFX
  extern std::u8string tunerPlugin;
#ifdef SHR3D_MIDI
  extern std::u8string tunerMidiDevice;
#endif // SHR3D_MIDI
  extern std::u8string tunerMidiPlugin;
#endif // SHR3D_SFX
#ifdef SHR3D_SFX_CORE_HEXFIN
  extern f32 tunerHexfinOnsetThreshold;
  extern f32 tunerHexfinReleaseThreshold;
#endif // SHR3D_SFX_CORE_HEXFIN
  extern f32 uiScale;
#ifdef SHR3D_OPENXR
  extern f32 uiXrZ;
#endif // SHR3D_OPENXR
#ifdef SHR3D_CUSTOM_CURSOR
  extern bool uiCursorCustom;
  extern i32 uiCursorSize;
#endif // SHR3D_CUSTOM_CURSOR
  extern vec4 uiColor[30];
#ifdef SHR3D_OPENXR
#ifdef SHR3D_OPENXR_PCVR
  extern bool xrEnabled;
#endif // SHR3D_OPENXR_PCVR
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4_AND_QUEST3
  extern XrController xrController;
#endif // SHR3D_OPENXR_CONTROLLER_PICO4_AND_QUEST3
  extern vec4 xrControllerColor[2];
  extern vec4 xrCursorColor[2];
  extern vec4 xrPointerColor;
  //    extern f32 xrUiCircularProjection;
#endif // SHR3D_OPENXR

  void init(
#ifdef SHR3D_GETOPT
          int argc, char* argv[]
#endif // SHR3D_GETOPT
          );
  void fini();
}

#endif // SETTINGS_H
