/* ========================================
 *  ADClip7 - ADClip7.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ADClip7_ADClip7_H
#define __ADClip7_ADClip7_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ADClip7 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class ADClip7 final : public SfxCoreExtensionV1
{
public:
    ADClip7();
    ~ADClip7();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double lastSampleL;
	double lastSampleR;
	float bL[22200];
	float bR[22200];
	int gcount;
	double lowsL;
	double lowsR;
	double iirLowsAL;
	double iirLowsAR;
	double iirLowsBL;
	double iirLowsBR;
	double refclipL;
	double refclipR;

    float A;
    float B;
    float C;
    float D;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
