/* ========================================
 *  Aura - Aura.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Aura_Aura_H
#define __Aura_Aura_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Aura {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Aura final : public SfxCoreExtensionV1
{
public:
    Aura();
    ~Aura();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double lastSampleL;
	double previousVelocityL;
	double lastSampleR;
	double previousVelocityR;
	
	double bL[21];
	double bR[21];
	double f[21];		
	

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
