/* ========================================
 *  BassAmp - BassAmp.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BassAmp_BassAmp_H
#define __BassAmp_BassAmp_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BassAmp {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class BassAmp final : public SfxCoreExtensionV1
{
public:
    BassAmp();
    ~BassAmp();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double LataLast6Sample;
	double LataLast5Sample;
	double LataLast4Sample;
	double LataLast3Sample;
	double LataLast2Sample;
	double LataLast1Sample;
	double LataHalfwaySample;
	double LataHalfDrySample;
	double LataHalfDiffSample;
	double LataLastDiffSample;
	double LataDrySample;
	double LataDiffSample;
	double LataPrevDiffSample;
	
	double LiirDriveSampleA;
	double LiirDriveSampleB;
	double LiirDriveSampleC;
	double LiirDriveSampleD;
	double LiirDriveSampleE;
	double LiirDriveSampleF;
	
	bool LWasNegative;
	bool LSubOctave;
	double LiirHeadBumpA;
	double LiirHeadBumpB;
	double LiirHeadBumpC;
	
	double LiirSubBumpA;
	double LiirSubBumpB;
	double LiirSubBumpC;
	
	double LiirSampleA;
	double LiirSampleB;
	double LiirSampleC;
	double LiirSampleD;
	double LiirSampleE;
	double LiirSampleF;
	double LiirSampleG;
	double LiirSampleH;
	double LiirSampleI;
	double LiirSampleJ;
	double LiirSampleK;
	double LiirSampleL;
	double LiirSampleM;
	double LiirSampleN;
	double LiirSampleO;
	double LiirSampleP;
	double LiirSampleQ;
	double LiirSampleR;
	double LiirSampleS;
	double LiirSampleT;
	double LiirSampleU;
	double LiirSampleV;
	double LiirSampleW;
	double LiirSampleX;
	double LiirSampleY;
	double LiirSampleZ;		
	
	double RataLast6Sample;
	double RataLast5Sample;
	double RataLast4Sample;
	double RataLast3Sample;
	double RataLast2Sample;
	double RataLast1Sample;
	double RataHalfwaySample;
	double RataHalfDrySample;
	double RataHalfDiffSample;
	double RataLastDiffSample;
	double RataDrySample;
	double RataDiffSample;
	double RataPrevDiffSample;
	
	double RiirDriveSampleA;
	double RiirDriveSampleB;
	double RiirDriveSampleC;
	double RiirDriveSampleD;
	double RiirDriveSampleE;
	double RiirDriveSampleF;
	
	bool RWasNegative;
	bool RSubOctave;
	double RiirHeadBumpA;
	double RiirHeadBumpB;
	double RiirHeadBumpC;
	
	double RiirSubBumpA;
	double RiirSubBumpB;
	double RiirSubBumpC;
	
	double RiirSampleA;
	double RiirSampleB;
	double RiirSampleC;
	double RiirSampleD;
	double RiirSampleE;
	double RiirSampleF;
	double RiirSampleG;
	double RiirSampleH;
	double RiirSampleI;
	double RiirSampleJ;
	double RiirSampleK;
	double RiirSampleL;
	double RiirSampleM;
	double RiirSampleN;
	double RiirSampleO;
	double RiirSampleP;
	double RiirSampleQ;
	double RiirSampleR;
	double RiirSampleS;
	double RiirSampleT;
	double RiirSampleU;
	double RiirSampleV;
	double RiirSampleW;
	double RiirSampleX;
	double RiirSampleY;
	double RiirSampleZ;		
	
	double ataK1;
	double ataK2;
	double ataK3;
	double ataK4;
	double ataK5;
	double ataK6;
	double ataK7;
	double ataK8; //end antialiasing variables
	
	bool flip; //drive things	
	int bflip;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
