/* ========================================
 *  BassDrive - BassDrive.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BassDrive.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BassDrive {

BassDrive::BassDrive()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 0.5;
	E = 0.5;
	for (int fcount = 0; fcount < 7; fcount++)
	{
		presenceInAL[fcount] = 0.0;
		presenceOutAL[fcount] = 0.0;
		highInAL[fcount] = 0.0;
		highOutAL[fcount] = 0.0;
		midInAL[fcount] = 0.0;
		midOutAL[fcount] = 0.0;
		lowInAL[fcount] = 0.0;
		lowOutAL[fcount] = 0.0;
		presenceInBL[fcount] = 0.0;
		presenceOutBL[fcount] = 0.0;
		highInBL[fcount] = 0.0;
		highOutBL[fcount] = 0.0;
		midInBL[fcount] = 0.0;
		midOutBL[fcount] = 0.0;
		lowInBL[fcount] = 0.0;
		lowOutBL[fcount] = 0.0;
		
		presenceInAR[fcount] = 0.0;
		presenceOutAR[fcount] = 0.0;
		highInAR[fcount] = 0.0;
		highOutAR[fcount] = 0.0;
		midInAR[fcount] = 0.0;
		midOutAR[fcount] = 0.0;
		lowInAR[fcount] = 0.0;
		lowOutAR[fcount] = 0.0;
		presenceInBR[fcount] = 0.0;
		presenceOutBR[fcount] = 0.0;
		highInBR[fcount] = 0.0;
		highOutBR[fcount] = 0.0;
		midInBR[fcount] = 0.0;
		midOutBR[fcount] = 0.0;
		lowInBR[fcount] = 0.0;
		lowOutBR[fcount] = 0.0;
	}
	flip = false;
	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BassDrive::getParameterCount() const
{
	return kNumParameters;
}

void BassDrive::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BassDrive::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BassDrive::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Presence", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "High", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mid", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Low", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Drive", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BassDrive::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BassDrive::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
