/* ========================================
 *  Baxandall2 - Baxandall2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Baxandall2_Baxandall2_H
#define __Baxandall2_Baxandall2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Baxandall2 {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Baxandall2 final : public SfxCoreExtensionV1
{
public:
    Baxandall2();
    ~Baxandall2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double trebleAL[9];
	double trebleBL[9];
	double bassAL[9];
	double bassBL[9];
	
	double trebleAR[9];
	double trebleBR[9];
	double bassAR[9];
	double bassBR[9];
	bool flip;
	
    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
