/* ========================================
 *  Bite - Bite.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Bite.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Bite {

Bite::Bite()
{
	A = 0.5;
	B = 1.0;
	sampleAL = 0.0;
	sampleBL = 0.0;
	sampleCL = 0.0;
	sampleDL = 0.0;
	sampleEL = 0.0;
	sampleFL = 0.0;
	sampleGL = 0.0;
	sampleHL = 0.0;
	sampleIL = 0.0;
	
	sampleAR = 0.0;
	sampleBR = 0.0;
	sampleCR = 0.0;
	sampleDR = 0.0;
	sampleER = 0.0;
	sampleFR = 0.0;
	sampleGR = 0.0;
	sampleHR = 0.0;
	sampleIR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Bite::getParameterCount() const
{
	return kNumParameters;
}

void Bite::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Bite::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Bite::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Bite", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Output Level", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Bite::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Bite::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
