/* ========================================
 *  BussColors4 - BussColors4.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BussColors4_BussColors4_H
#define __BussColors4_BussColors4_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BussColors4 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class BussColors4 final : public SfxCoreExtensionV1
{
public:
    BussColors4();
    ~BussColors4();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:

	double bL[175]; //full buffer for high sample rates. Scales to 192K
	double bR[175]; //full buffer for high sample rates. Scales to 192K
	double dL[100]; //buffer for calculating sag as it relates to the dynamic impulse synthesis. To 192K.
	double dR[100]; //buffer for calculating sag as it relates to the dynamic impulse synthesis. To 192K.
	int c[35]; //just the number of taps we use, doesn't have to scale
	double g[9]; //console model
	double outg[9]; //console model
	double controlL;
	double controlR;
	double slowdynL;
	double slowdynR;
	int gcount;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
