/* ========================================
 *  Chamber - Chamber.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Chamber.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Chamber {

Chamber::Chamber()
{
	A = 0.35f;
	B = 0.35;
	C = 0.35;
	D = 0.35;
	E = 0.35;
	
	iirAL = 0.0; iirAR = 0.0;
	iirBL = 0.0; iirBR = 0.0;
	iirCL = 0.0; iirCR = 0.0;
	
	for(int count = 0; count < 19999; count++) {aEL[count] = 0.0;aER[count] = 0.0;}
	for(int count = 0; count < 12360; count++) {aFL[count] = 0.0;aFR[count] = 0.0;}
	for(int count = 0; count < 7639; count++) {aGL[count] = 0.0;aGR[count] = 0.0;}
	for(int count = 0; count < 4721; count++) {aHL[count] = 0.0;aHR[count] = 0.0;}
	for(int count = 0; count < 2915; count++) {aAL[count] = 0.0;aAR[count] = 0.0;}
	for(int count = 0; count < 1803; count++) {aBL[count] = 0.0;aBR[count] = 0.0;}
	for(int count = 0; count < 1114; count++) {aCL[count] = 0.0;aCR[count] = 0.0;}
	for(int count = 0; count < 688; count++) {aDL[count] = 0.0;aDR[count] = 0.0;}
	for(int count = 0; count < 425; count++) {aIL[count] = 0.0;aIR[count] = 0.0;}
	for(int count = 0; count < 263; count++) {aJL[count] = 0.0;aJR[count] = 0.0;}
	for(int count = 0; count < 162; count++) {aKL[count] = 0.0;aKR[count] = 0.0;}
	for(int count = 0; count < 100; count++) {aLL[count] = 0.0;aLR[count] = 0.0;}
	
	feedbackAL = 0.0; feedbackAR = 0.0;
	feedbackBL = 0.0; feedbackBR = 0.0;
	feedbackCL = 0.0; feedbackCR = 0.0;
	feedbackDL = 0.0; feedbackDR = 0.0;
	previousAL = 0.0; previousAR = 0.0;
	previousBL = 0.0; previousBR = 0.0;
	previousCL = 0.0; previousCR = 0.0;
	previousDL = 0.0; previousDR = 0.0;
	
	for(int count = 0; count < 9; count++) {lastRefL[count] = 0.0;lastRefR[count] = 0.0;}
	
	countI = 1;
	countJ = 1;
	countK = 1;
	countL = 1;
	
	countA = 1;
	countB = 1;
	countC = 1;
	countD = 1;	
	
	countE = 1;
	countF = 1;
	countG = 1;
	countH = 1;
	cycle = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Chamber::getParameterCount() const
{
  return kNumParameters;
}

void Chamber::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Chamber::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Chamber::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Bigness", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Longness", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Liteness", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Darkness", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Wetness", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Chamber::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Chamber::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
