/* ========================================
 *  Channel8 - Channel8.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Channel8.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Channel8 {

Channel8::Channel8()
{
	consoletype = 0.0;
	drive = 0.0;
	output = 1.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	iirSampleLA = 0.0;
	iirSampleRA = 0.0;
	iirSampleLB = 0.0;
	iirSampleRB = 0.0;
	lastSampleAL = lastSampleBL = lastSampleCL = 0.0;
	lastSampleAR = lastSampleBR = lastSampleCR = 0.0;
	flip = false;
	iirAmount = 0.005832;
	threshold = 0.33362176; //instantiating with Neve values
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Channel8::getParameterCount() const
{
  return kNumParameters;
}

void Channel8::setParameter(int index, float value) {
    switch (index) {
        case kParamA: consoletype = value; break;
        case kParamB: drive = value; break;
        case kParamC: output = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
	//we can also set other defaults here, and do calculations that only have to happen
	//once when parameters actually change. Here is the 'popup' setting its (global) values.
	//variables can also be set in the processreplacing loop, and there they'll be set every buffersize
	//here they're set when a parameter's actually changed, which should be less frequent, but
	//you must use global variables in the Channel4.h file to do it.
	switch((int)( consoletype * 2.999 ))
	{  
		case 0: iirAmount = 0.005832; threshold = 0.33362176; break; //Neve
		case 1: iirAmount = 0.004096; threshold = 0.59969536; break; //API
		case 2: iirAmount = 0.004913; threshold = 0.84934656; break; //SSL			
		default: break; //should not happen
	}		
}

float Channel8::getParameter(int index) {
    switch (index) {
        case kParamA: return consoletype; break;
        case kParamB: return drive; break;
        case kParamC: return output; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Channel8::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Console Type", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Drive", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Channel8::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( consoletype * 2.999 )) //0 to almost edge of # of params
		{	case 0: strncpy (text, "Neve", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "API", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "SSL", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //completed consoletype 'popup' parameter, exit
		case kParamB: int2string ((int)(drive*200), text, kVstMaxParamStrLen); break;
		case kParamC: float2string (output, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Channel8::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "%", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break; //the percent
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
