/* ========================================
 *  ConsoleMDChannel - ConsoleMDChannel.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ConsoleMDChannel.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ConsoleMDChannel {

ConsoleMDChannel::ConsoleMDChannel()
{
	A = 0.5;
	B = 0.25;
	C = 0.0;
	D = 0.5;
	E = 0.5;
	F = 0.5;
	
	for (int x = 0; x < 17; x++) pearA[x] = 0.0;
	for (int x = 0; x < 21; x++) pearB[x] = 0.0;
	for(int count = 0; count < 2004; count++) {mpkL[count] = 0.0; mpkR[count] = 0.0;}
	for(int count = 0; count < 65; count++) {f[count] = 0.0;}
	prevfreqMPeak = -1;
	prevamountMPeak = -1;
	mpc = 1;	
	bassA = bassB = 0.0;
	gainA = gainB = 1.0;	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ConsoleMDChannel::getParameterCount() const
{
  return kNumParameters;
}

void ConsoleMDChannel::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ConsoleMDChannel::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ConsoleMDChannel::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Treble", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "MidFreq", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "MidPeak", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Bass", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Pan", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Fader", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ConsoleMDChannel::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ConsoleMDChannel::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
