/* ========================================
 *  ConsoleXSubIn - ConsoleXSubIn.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ConsoleXSubIn_ConsoleXSubIn_H
#define __ConsoleXSubIn_ConsoleXSubIn_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ConsoleXSubIn {
enum {
  kNumParameters = 0
}; //


class ConsoleXSubIn final : public SfxCoreExtensionV1
{
public:
    ConsoleXSubIn();
    ~ConsoleXSubIn();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	enum {
		biq_freq,
		biq_reso,
		biq_a0,
		biq_a1,
		biq_a2,
		biq_b1,
		biq_b2,
		biq_sL1,
		biq_sL2,
		biq_sR1,
		biq_sR2,
		biq_total
	};
	double biquad[biq_total];
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
