/* ========================================
 *  CrunchyGrooveWear - CrunchyGrooveWear.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __CrunchyGrooveWear_CrunchyGrooveWear_H
#define __CrunchyGrooveWear_CrunchyGrooveWear_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::CrunchyGrooveWear {
enum {
	kParamA = 0,
	kParamB = 1,
	kNumParameters = 2
}; //


class CrunchyGrooveWear final : public SfxCoreExtensionV1
{
public:
    CrunchyGrooveWear();
    ~CrunchyGrooveWear();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double aMidL[21];
	double aMidPrevL;
	double bMidL[21];
	double bMidPrevL;
	double cMidL[21];
	double cMidPrevL;
	double dMidL[21];
	double dMidPrevL;
	
	double aMidR[21];
	double aMidPrevR;
	double bMidR[21];
	double bMidPrevR;
	double cMidR[21];
	double cMidPrevR;
	double dMidR[21];
	double dMidPrevR;
	
	double fMid[21];		
	
    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
