/* ========================================
 *  DeBess - DeBess.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "DeBess.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::DeBess {

DeBess::DeBess()
{
	A = 0.0;
	B = 0.5;
	C = 0.5;
	D = 0.5;
	E = 0.0;
	for (int x = 0; x < 41; x++) {
		sL[x] = 0.0; mL[x] = 0.0; cL[x] = 0.0;
		sR[x] = 0.0; mR[x] = 0.0; cR[x] = 0.0;
	}
	ratioAL = ratioBL = 1.0;
	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	ratioAR = ratioBR = 1.0;
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	
	flip = false;	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int DeBess::getParameterCount() const
{
  return kNumParameters;
}

void DeBess::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float DeBess::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void DeBess::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Intense", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Sharp", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Depth", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Filter", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Sense", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void DeBess::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void DeBess::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: 
			if (E > 0.499999) strncpy (text, "Vox", kVstMaxParamStrLen);
			else strncpy (text, "Ess", kVstMaxParamStrLen);
			break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
