/* ========================================
 *  DeRez2 - DeRez2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DeRez2_DeRez2_H
#define __DeRez2_DeRez2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DeRez2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class DeRez2 final : public SfxCoreExtensionV1
{
public:
    DeRez2();
    ~DeRez2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double lastSampleL;
	double heldSampleL;
	double lastDrySampleL;
	double lastOutputSampleL;

	double lastSampleR;
	double heldSampleR;
	double lastDrySampleR;
	double lastOutputSampleR;

	double position;
	double incrementA;
	double incrementB;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
