/* ========================================
 *  Distance2 - Distance2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Distance2_Distance2_H
#define __Distance2_Distance2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Distance2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Distance2 final : public SfxCoreExtensionV1
{
public:
    Distance2();
    ~Distance2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double lastSampleAL;
	double lastSampleBL;
	double lastSampleCL;
	double lastSampleDL;
	double lastSampleEL;
	double lastSampleFL;
	double lastSampleGL;
	double lastSampleHL;
	double lastSampleIL;
	double lastSampleJL;
	double lastSampleKL;
	double lastSampleLL;
	double lastSampleML;

	double lastSampleAR;
	double lastSampleBR;
	double lastSampleCR;
	double lastSampleDR;
	double lastSampleER;
	double lastSampleFR;
	double lastSampleGR;
	double lastSampleHR;
	double lastSampleIR;
	double lastSampleJR;
	double lastSampleKR;
	double lastSampleLR;
	double lastSampleMR;

	double thresholdA;
	double thresholdB;
	double thresholdC;
	double thresholdD;
	double thresholdE;
	double thresholdF;
	double thresholdG;
	double thresholdH;
	double thresholdI;
	double thresholdJ;
	double thresholdK;
	double thresholdL;
	double thresholdM;
	
	double thirdSampleL;
	double lastSampleL;
	
	double thirdSampleR;
	double lastSampleR;
	
    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
