/* ========================================
 *  Distance3 - Distance3.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Distance3.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Distance3 {

Distance3::Distance3()
{
	A = 0.5;
	B = 0.5;
	C = 1.0;
	
	prevresultAL = lastclampAL = clampAL = changeAL = lastAL = 0.0;
	prevresultBL = lastclampBL = clampBL = changeBL = lastBL = 0.0;
	prevresultCL = lastclampCL = clampCL = changeCL = lastCL = 0.0;
	prevresultAR = lastclampAR = clampAR = changeAR = lastAR = 0.0;
	prevresultBR = lastclampBR = clampBR = changeBR = lastBR = 0.0;
	prevresultCR = lastclampCR = clampCR = changeCR = lastCR = 0.0;
	for(int count = 0; count < dscBuf+2; count++) {
		dBaL[count] = 0.0;
		dBbL[count] = 0.0;
		dBcL[count] = 0.0;
		dBaR[count] = 0.0;
		dBbR[count] = 0.0;
		dBcR[count] = 0.0;
	}
	dBaPosL = 0.0;
	dBbPosL = 0.0;
	dBcPosL = 0.0;
	dBaPosR = 0.0;
	dBbPosR = 0.0;
	dBcPosR = 0.0;
	dBaXL = 1;
	dBbXL = 1;
	dBcXL = 1;
	dBaXR = 1;
	dBbXR = 1;
	dBcXR = 1;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Distance3::getParameterCount() const
{
  return kNumParameters;
}

void Distance3::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Distance3::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Distance3::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Distance", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Top dB", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Distance3::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*10.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*70.0)+70.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Distance3::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "miles", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
