/* ========================================
 *  Distance3 - Distance3.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Distance3_Distance3_H
#define __Distance3_Distance3_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Distance3 {
enum {
	kParamA =0,
	kParamB =1,
	kParamC =2,
  kNumParameters = 3
}; //
const int dscBuf = 90;


class Distance3 final : public SfxCoreExtensionV1
{
public:
    Distance3();
    ~Distance3();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
    float A;
    float B;
    float C;
	
	double lastclampAL;
	double clampAL;
	double changeAL;
	double prevresultAL;
	double lastAL;
	
	double lastclampBL;
	double clampBL;
	double changeBL;
	double prevresultBL;
	double lastBL;
	
	double lastclampCL;
	double clampCL;
	double changeCL;
	double prevresultCL;
	double lastCL;
	
	double dBaL[dscBuf+5];
	double dBaPosL;
	int dBaXL;
	
	double dBbL[dscBuf+5];
	double dBbPosL;
	int dBbXL;
	
	double dBcL[dscBuf+5];
	double dBcPosL;
	int dBcXL;

	double lastclampAR;
	double clampAR;
	double changeAR;
	double prevresultAR;
	double lastAR;
	
	double lastclampBR;
	double clampBR;
	double changeBR;
	double prevresultBR;
	double lastBR;
	
	double lastclampCR;
	double clampCR;
	double changeCR;
	double prevresultCR;
	double lastCR;
	
	double dBaR[dscBuf+5];
	double dBaPosR;
	int dBaXR;
	
	double dBbR[dscBuf+5];
	double dBbPosR;
	int dBbXR;
	
	double dBcR[dscBuf+5];
	double dBcPosR;
	int dBcXR;
	

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
