/* ========================================
 *  Drive - Drive.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Drive.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Drive {

Drive::Drive()
{
	A = 0.0;
	B = 0.0;
	C = 1.0;
	D = 1.0;
	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	fpFlip = true;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Drive::getParameterCount() const
{
  return kNumParameters;
}

void Drive::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        case kParamC: C = value; break;
        case kParamD: D = value; break; //this is the popup, stored as a float
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Drive::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Drive::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Drive", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Highpass", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Out Level", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Drive::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*100.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Drive::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "%", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, " ", kVstMaxParamStrLen); break; //the popup
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
