/* ========================================
 *  EQ - EQ.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __EQ_EQ_H
#define __EQ_EQ_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::EQ {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kNumParameters = 8
}; //


class EQ final : public SfxCoreExtensionV1
{
public:
    EQ();
    ~EQ();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double lastSampleL;
	double last2SampleL;
	double lastSampleR;
	double last2SampleR;
	
	//begin EQ
	double iirHighSampleLA;
	double iirHighSampleLB;
	double iirHighSampleLC;
	double iirHighSampleLD;
	double iirHighSampleLE;
	double iirLowSampleLA;
	double iirLowSampleLB;
	double iirLowSampleLC;
	double iirLowSampleLD;
	double iirLowSampleLE;
	double iirHighSampleL;
	double iirLowSampleL;
	
	double iirHighSampleRA;
	double iirHighSampleRB;
	double iirHighSampleRC;
	double iirHighSampleRD;
	double iirHighSampleRE;
	double iirLowSampleRA;
	double iirLowSampleRB;
	double iirLowSampleRC;
	double iirLowSampleRD;
	double iirLowSampleRE;
	double iirHighSampleR;
	double iirLowSampleR;
	
	double tripletLA;
	double tripletLB;
	double tripletLC;
	double tripletFactorL;
	
	double tripletRA;
	double tripletRB;
	double tripletRC;
	double tripletFactorR;
	
	double lowpassSampleLAA;
	double lowpassSampleLAB;
	double lowpassSampleLBA;
	double lowpassSampleLBB;
	double lowpassSampleLCA;
	double lowpassSampleLCB;
	double lowpassSampleLDA;
	double lowpassSampleLDB;
	double lowpassSampleLE;
	double lowpassSampleLF;
	double lowpassSampleLG;
	
	double lowpassSampleRAA;
	double lowpassSampleRAB;
	double lowpassSampleRBA;
	double lowpassSampleRBB;
	double lowpassSampleRCA;
	double lowpassSampleRCB;
	double lowpassSampleRDA;
	double lowpassSampleRDB;
	double lowpassSampleRE;
	double lowpassSampleRF;
	double lowpassSampleRG;
	
	double highpassSampleLAA;
	double highpassSampleLAB;
	double highpassSampleLBA;
	double highpassSampleLBB;
	double highpassSampleLCA;
	double highpassSampleLCB;
	double highpassSampleLDA;
	double highpassSampleLDB;
	double highpassSampleLE;
	double highpassSampleLF;
	
	double highpassSampleRAA;
	double highpassSampleRAB;
	double highpassSampleRBA;
	double highpassSampleRBB;
	double highpassSampleRCA;
	double highpassSampleRCB;
	double highpassSampleRDA;
	double highpassSampleRDB;
	double highpassSampleRE;
	double highpassSampleRF;
	
	bool flip;
	int flipthree;
	//end EQ
	

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
	
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
