/* ========================================
 *  Ensemble - Ensemble.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Ensemble.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Ensemble {

Ensemble::Ensemble()
{
	A = 0.5;
	B = 0.0;
	C = 1.0;
	D = 1.0;

	for(int count = 0; count < totalsamples-1; count++) {dL[count] = 0; dR[count] = 0;}
	for(int count = 0; count < 49; count++) {sweep[count] = 3.141592653589793238 / 2.0;}
	gcount = 0;
	airPrevL = 0.0;
	airEvenL = 0.0;
	airOddL = 0.0;
	airFactorL = 0.0;
	airPrevR = 0.0;
	airEvenR = 0.0;
	airOddR = 0.0;
	airFactorR = 0.0;
	fpFlip = true;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Ensemble::getParameterCount() const
{
  return kNumParameters;
}

void Ensemble::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Ensemble::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Ensemble::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Ensemble", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Fullness", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Brighten", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Ensemble::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (floor((A*46.0)+2.9), text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Ensemble::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "vox", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
