/* ========================================
 *  FathomFive - FathomFive.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "FathomFive.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::FathomFive {

FathomFive::FathomFive()
{
	A = 1.0;
	B = 0.0;
	C = 0.5;
	D = 1.0;
	WasNegativeL = false;
	SubOctaveL = false;
	iirSampleLA = 0.0;
	iirSampleLB = 0.0;
	iirSampleLC = 0.0;
	iirSampleLD = 0.0;
	WasNegativeR = false;
	SubOctaveR = false;
	iirSampleRA = 0.0;
	iirSampleRB = 0.0;
	iirSampleRC = 0.0;
	iirSampleRD = 0.0;
	
	
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int FathomFive::getParameterCount() const
{
  return kNumParameters;
}

void FathomFive::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
	//we can also set other defaults here, and do calculations that only have to happen
	//once when parameters actually change. Here is the 'popup' setting its (global) values.
	//variables can also be set in the processreplacing loop, and there they'll be set every buffersize
	//here they're set when a parameter's actually changed, which should be less frequent, but
	//you must use global variables in the FathomFive.h file to do it.
}

float FathomFive::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void FathomFive::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Root Note", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "SubOctave", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Frequency", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void FathomFive::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void FathomFive::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
